/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.toma.gunsrpg.common.quests.quest.KillEntityData;
import dev.toma.gunsrpg.common.quests.quest.QuestType;
import dev.toma.gunsrpg.common.quests.quest.area.IQuestAreaProvider;
import dev.toma.gunsrpg.common.quests.quest.area.QuestAreaScheme;
import dev.toma.gunsrpg.common.quests.quest.filter.EntityFilterType;
import dev.toma.gunsrpg.common.quests.quest.filter.IEntityFilter;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.JSONUtils;

public class KillInAreaData
extends KillEntityData
implements IQuestAreaProvider {
    private final QuestAreaScheme areaScheme;

    public KillInAreaData(IEntityFilter filter, int killCount, QuestAreaScheme scheme) {
        super(filter, killCount);
        this.areaScheme = scheme;
    }

    @Override
    public QuestAreaScheme getAreaScheme() {
        return this.areaScheme;
    }

    @Override
    public String toString() {
        return String.format("KillEntitiesInArea - Filter: %s, Count: %d, Area: { %s }", this.getEntityFilter().toString(), this.getKillTarget(), this.areaScheme.toString());
    }

    public static final class Serializer
    implements QuestType.IQuestDataResolver<KillInAreaData> {
        @Override
        public KillInAreaData resolve(JsonElement element) throws JsonParseException {
            JsonObject object = JsonHelper.asJsonObject(element);
            JsonElement filterElement = object.get("entities");
            Object filter = EntityFilterType.resolveJsonFile(filterElement);
            int count = JSONUtils.func_151208_a((JsonObject)object, (String)"count", (int)1);
            QuestAreaScheme areaScheme = QuestAreaScheme.fromJson(JSONUtils.func_152754_s((JsonObject)object, (String)"area"));
            return new KillInAreaData((IEntityFilter)filter, count, areaScheme);
        }

        @Override
        public CompoundNBT serialize(KillInAreaData data) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("kills", data.getKillTarget());
            nbt.func_218657_a("area", (INBT)data.areaScheme.toNbt());
            nbt.func_218657_a("filter", (INBT)EntityFilterType.serializeNbt(data.getEntityFilter()));
            return nbt;
        }

        @Override
        public KillInAreaData deserialize(CompoundNBT nbt) {
            int kills = nbt.func_74762_e("kills");
            QuestAreaScheme scheme = QuestAreaScheme.fromNbt(nbt.func_74775_l("area"));
            Object filter = EntityFilterType.deserializeNbt(nbt.func_74775_l("filter"));
            return new KillInAreaData((IEntityFilter)filter, kills, scheme);
        }
    }
}

